<?php if(!defined('IN_CMS')) exit;?>{include file="top.php" type="admin"}
</head>
<body>

    <div class="position">当前位置：应用管理 > <a href="{$plug}">插件管理</a> > <a href="{U('index')}">智谱AI写作</a></div>
    <div class="ui-borders">
        <!---->
        <div class="ui-tabs ui-tabs-white" data-href="1">
            <ul class="ui-tabs-nav">
                <li class="active"><a href="{U('index')}">智谱AI写作</a></li>
                <li><a href="{U('config')}">参数设置</a></li>
            </ul>
            <div class="ui-tabs-content">
            
                <div class="ui-tabs-pane active">
                <!---->
                <div class="navbar">
                    <div class="lefter">
                        <span class="ui-btn-group blue">
                            <a class="ui-btn-group-item{if $type==0} active{/if}" href="{U('index','type=0')}">全部</a>
                            <a class="ui-btn-group-item{if $type==1} active{/if}" href="{U('index','type=1')}">未创作</a>
                            <a class="ui-btn-group-item{if $type==2} active{/if}" href="{U('index','type=2')}">成功</a>
                            <a class="ui-btn-group-item{if $type==3} active{/if}" href="{U('index','type=3')}">失败</a>
                        </span>
                        <a href="{U('clear')}" class="ui-action ui-btn ui-ml yellow" data-type="clear" data-data="token={$token}">清理失败</a>
                    </div>
                    
                    <div class="righter ui-text-right">
                        <a href="{U('add')}" data-size="55%:60%" class="ui-btn blue ui-mr-sm ui-iframe">添加标题</a>
                        <a href="{U('action')}" data-size="400px:260px" data-foot="0" class="ui-btn yellow ui-mr-sm ui-iframe">一键写作</a>
                        <a href="javascript:;" class="ui-btn ui-modal-show" data-target="#my-modal-1">定时写作</a>
                    </div>
                    
                </div>
                    <div class="ui-table-wrap">
                    <table class="ui-table border hover blue ui-mb ui-mt-15">
                        <tr>
                            <th width="80" height="30">ID</th>
                            <th>标题</th>
                            <th width="150">分类</th>
                            <th width="100">写作结果</th>
                            <th width="170">完成时间</th>
                            <th width="120">操作</th>
                        </tr>
                        {cms:rs pagesize="20" table="cms_plug_chatglm a left join cms_class b on a.classid=b.cateid" where="$where" order="id desc"}
                        {rs:eof}
                        <tr>
                            <td colspan="6" align="center">暂无资料</td>
                        </tr>
                        {/rs:eof}
                        <tr class="ui-font-14">
                            <td>{$rs.id}</td>
                            <td class="ui-text-left" style="min-width:160px;">{$rs.title}</td>
                            <td>{$rs.cate_name}</a></td>
                            <td>{if $rs.cid<0}<span class="ui-badge small red ui-mr-sm"></span>失败<br>【<a href="{U('why','id='.$rs.id.'')}" class="view">原因</a>】{/if}{if $rs.cid==0}<span class="ui-badge small ui-mr-sm"></span><span class="ui-text-gray">未创作</span>{/if}{if $rs.cid>0}<span class="ui-badge small green ui-mr-sm"></span>成功{/if}</td>
                            <td>{if $rs.cid>0}{date('Y-m-d H:i',$rs.createdate)}{/if}</td>
                            <td class="link"><a href="{if $rs.cid<=0}javascript:;{else}{U('show','id='.$rs.cid.'')}{/if}" class="{if $rs.cid<=0}ui-disabled{/if}"{if $rs.cid>0} target="_blank"{/if}>预览</a>　<a href="{U('del')}" class="ui-action" data-data="id={$rs.id}&token={$token}">删除</a></td>
                        </tr>
                        {/cms:rs}
                    </table>
            		</div>
                    {if $total_rs!=0}
                    <div class="ui-page center blue mid">
                        <div class="ui-page-list"><ul>{$showpage}</ul></div>
                    </div>
                    {/if}
                <!---->
                </div>

            </div>
        </div>
        <!---->
    </div>
    
 	<div class="ui-modal" id="my-modal-1">
        <div class="ui-modal-header">
            <div class="ui-modal-title">定时写作</div>
            <div class="ui-modal-close">×</div>
        </div>
        <div class="ui-modal-body">
        	<!--b-->
            <div class="ui-menu blue">
            	<div class="ui-menu-name">Url地址</div>
            </div>
            <div class="ui-form-group ui-mt-20">
                <div class="ui-input-group">
                    <input type="text" id="openurl" class="ui-form-ip radius-right-none" readonly value="{WEB_URL}{WEB_ROOT}plug/chatglm/app/begin.php">
                    <a class="after blue ui-copy" data-target="#openurl">复制</a>
                </div>                                                                                                
            </div>
            <div class="ui-menu red">
            	<div class="ui-menu-name">使用示范</div>
            </div>
            <div class="ui-mt-20">以宝塔为例，在【计划任务】添加【访问URL】，如下图：</div>
            <p class="ui-mt-20"><img src="data:image/png;base64,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"></p>
            <!--e-->
        </div>
    </div>
    
<script>
$(function()
{
	$(".view").click(function()
	{
		event.preventDefault();
		var url=$(this).attr("href");
		$.ajax(
		{
			type:'get',
			cache:false,
			url:url,
			error:function(e){alert(e.responseText);},
			success:function(d)
			{
				$.dialog(
				{
					title:"查看原因",
					text:d,
					ok:function(e)
					{
						e.close();
					}
				});
			}
		})
	});
})
</script>
</body>
</html>